#include <amxmodx>
#include <amxmisc>
#include <cstrike>

#define PLUGIN "Fraglimit Advanced"
#define VERSION "1.0"
#define AUTHOR "Sho0ter"

#define is_valid_player(%1) (1 <= %1 <= 32)

#define TEMP_KILLS 0
#define TEMP_DEATHS 1
#define TEMP_HS 2

#define MCOUNT 9
#define MAX_STATS 10000
#define MOTDLEN 1536
#define MOTDLEN2 1535

enum STATS
{
	NAME[32],
	IP[32],
	STEAMID[34],
	WINS,
	SCORE,
	KILLS,
	DEATHS,
	TIME,
	RANKED,
	TEMPSCORE
}

new Music[MCOUNT][] = 
{
	"media/Half-Life01.mp3",
	"media/Half-Life02.mp3",
	"media/Half-Life03.mp3",
	"media/Half-Life08.mp3",
	"media/Half-Life11.mp3",
	"media/Half-Life12.mp3",
	"media/Half-Life13.mp3",
	"media/Half-Life16.mp3",
	"media/Half-Life17.mp3"
}

new Stats[MAX_STATS + 1][STATS]
new Temp[33][3]

new PcvarEnable
new PcvarLimit
new PcvarInformer
new PcvarStats
new PcvarType
new PcvarBy
new PcvarTop15
new PcvarRank
new PcvarRankStats
new PcvarPrune
new PcvarMotd
new PcvarMusic
new PcvarMaplist
new PcvarCycle
new PcvarFfa


new WinnerName[32]
new Winnerid
new StatNum

new bool:Winner
new bool:Recheaded

new gMsgHud
new gMsgHud2

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_dictionary("fraglimit.txt")
	PcvarEnable = register_cvar("fl_enable", "1")
	PcvarLimit = register_cvar("fl_limit", "100")
	PcvarInformer = register_cvar("fl_informer", "1")
	PcvarStats = register_cvar("fl_stats", "1")
	PcvarType = register_cvar("fl_stats_type", "1")
	PcvarBy = register_cvar("fl_stats_by", "1")
	PcvarTop15 = register_cvar("fl_stats_top15", "1")
	PcvarRank = register_cvar("fl_stats_rank", "1")
	PcvarRankStats = register_cvar("fl_stats_rankstats", "1")
	PcvarPrune = register_cvar("fl_stats_prune", "30")
	PcvarMotd = register_cvar("fl_winner_motd", "1")
	PcvarMusic = register_cvar("fl_music", "1")
	PcvarMaplist = register_cvar("fl_maplist", "maps.ini")
	PcvarCycle = register_cvar("fl_cycle", "1")
	PcvarFfa = register_cvar("fl_ffa", "0")
	LoadConfig()
	register_concmd("fl_stats_reset", "CmdReset", ADMIN_RCON, " - Reset Fraglimit Stats")
	if(get_pcvar_num(PcvarTop15) && get_pcvar_num(PcvarStats) && get_pcvar_num(PcvarEnable))
	{
		register_clcmd("say /top15", "CmdTop15")
		register_clcmd("say_team /top15", "CmdTop15")
	}
	if(get_pcvar_num(PcvarRank) && get_pcvar_num(PcvarStats) && get_pcvar_num(PcvarEnable))
	{
		register_clcmd("say /rank", "CmdRank")
		register_clcmd("say_team /rank", "CmdRank")
	}
	if(get_pcvar_num(PcvarRankStats) && get_pcvar_num(PcvarStats) && get_pcvar_num(PcvarEnable))
	{
		register_clcmd("say /rankstats", "CmdRankStats")
		register_clcmd("say /rankstats", "CmdRankStats")
	}
	register_event("DeathMsg","PlayerDeath","a")
	if(get_pcvar_num(PcvarInformer) && get_pcvar_num(PcvarEnable))
	{
		set_task(1.0, "Informer", 78877887, "", 0, "b")
	}
	gMsgHud = CreateHudSyncObj()
	gMsgHud2 = CreateHudSyncObj()
	if(get_pcvar_num(PcvarStats) && get_pcvar_num(PcvarEnable))
	{
		LoadStats()
	}
	if(get_pcvar_num(PcvarEnable))
	{
		RandomizeMap(1, 0)
	}
	return PLUGIN_CONTINUE
}

public LoadConfig()
{
	new cFile[128]
	get_configsdir(cFile, charsmax(cFile))
	format(cFile, charsmax(cFile), "%s/fraglimit.cfg", cFile)
	if(file_exists(cFile))
	{
		server_cmd("exec %s", cFile)
	}
	else
	{
		log_amx("Config file <%s> not found!", cFile)
	}
	return PLUGIN_CONTINUE
}

public LoadStats()
{
	new cFile[128], Len, TempStat[256], TempWins[32], TempScore[32], TempKills[32], TempDeaths[32], TempTime[32]
	get_datadir(cFile, charsmax(cFile))
	format(cFile, charsmax(cFile), "%s/fraglimit.dat", cFile)
	if(file_exists(cFile))
	{
		new i
		new stats_size = file_size(cFile, 1)
		if(stats_size >= MAX_STATS)
		{
			delete_file(cFile)
			Recheaded = true
			log_amx("Stats limit <%d> recheaded, clear all stats...", MAX_STATS)
			return PLUGIN_CONTINUE
		}
		while(i <= stats_size && read_file(cFile, i , TempStat, charsmax(TempStat), Len))
		{
			i++
			if(TempStat[0] == ';' || !Len)
			{
				continue
			}
			parse(TempStat, Stats[StatNum][NAME], 31, Stats[StatNum][IP], 31, Stats[StatNum][STEAMID], 33, TempWins, 31, TempScore, 31, TempKills, 31, TempDeaths, 31, TempTime, 31)
			new Clear = str_to_num(TempTime) + (get_pcvar_num(PcvarPrune) * 24 * 60 * 60)
			new Current = get_systime(0)
			if(Current >= Clear && get_pcvar_num(PcvarPrune))
			{
				continue
			}
			Stats[StatNum][WINS] = str_to_num(TempWins)
			Stats[StatNum][SCORE] = str_to_num(TempScore)
			if(Stats[StatNum][SCORE] < 0)
			{
				Stats[StatNum][SCORE] = 0
			}
			Stats[StatNum][KILLS] = str_to_num(TempKills)
			Stats[StatNum][DEATHS] = str_to_num(TempDeaths)
			Stats[StatNum][TIME] = str_to_num(TempTime)
			Stats[StatNum][RANKED] = 1
			StatNum++
		}
		log_amx("Loaded %d stats from file", StatNum)
	}
	else
	{
		log_amx("Stats file not found!")
		return PLUGIN_CONTINUE
	}
	new m 
	new n_name[32], n_ip[32], n_steamid[34], n_wins, n_score, n_kills, n_deaths, n_time, n_ranked
	for(new i = 1; i < StatNum; i++) // Thanks to KORD_12.7 (Lambda Core) for rank calculate code
	{
		copy(n_name, 31, Stats[i][NAME])
		copy(n_ip, 31, Stats[i][IP])
		copy(n_steamid, 33, Stats[i][STEAMID])
		n_wins = Stats[i][WINS]
		n_score = Stats[i][SCORE]
		n_kills = Stats[i][KILLS]
		n_deaths = Stats[i][DEATHS]
		n_time = Stats[i][TIME]
		n_ranked = Stats[i][RANKED]
		m = i - 1
		if(get_pcvar_num(PcvarType) == 1)
		{
			while(m >= 0 && Stats[m][SCORE] < n_score)
			{
				copy(Stats[m + 1][NAME], 31, Stats[m][NAME])
				copy(Stats[m + 1][IP], 31, Stats[m][IP])
				copy(Stats[m + 1][STEAMID], 33, Stats[m][STEAMID])
				Stats[m + 1][WINS] = Stats[m][WINS]
				Stats[m + 1][SCORE] = Stats[m][SCORE]
				Stats[m + 1][KILLS] = Stats[m][KILLS]
				Stats[m + 1][DEATHS] = Stats[m][DEATHS]
				Stats[m + 1][TIME] = Stats[m][TIME]
				Stats[m + 1][RANKED] = Stats[m][RANKED]
				m = m - 1
				copy(Stats[m + 1][NAME], 31, n_name)
				copy(Stats[m + 1][IP], 31, n_ip)
				copy(Stats[m + 1][STEAMID], 33, n_steamid)
				Stats[m + 1][WINS] = n_wins
				Stats[m + 1][SCORE] = n_score
				Stats[m + 1][KILLS] = n_kills
				Stats[m + 1][DEATHS] = n_deaths
				Stats[m + 1][TIME] = n_time
				Stats[m + 1][RANKED] = n_ranked
			} 
		}
		else
		{
			while(m >= 0 && Stats[m][WINS] < n_wins)
			{
				copy(Stats[m + 1][NAME], 31, Stats[m][NAME])
				copy(Stats[m + 1][IP], 31, Stats[m][IP])
				copy(Stats[m + 1][STEAMID], 33, Stats[m][STEAMID])
				Stats[m + 1][WINS] = Stats[m][WINS]
				Stats[m + 1][SCORE] = Stats[m][SCORE]
				Stats[m + 1][KILLS] = Stats[m][KILLS]
				Stats[m + 1][DEATHS] = Stats[m][DEATHS]
				Stats[m + 1][TIME] = Stats[m][TIME]
				Stats[m + 1][RANKED] = Stats[m][RANKED]
				m = m - 1
				copy(Stats[m + 1][NAME], 31, n_name)
				copy(Stats[m + 1][IP], 31, n_ip)
				copy(Stats[m + 1][STEAMID], 33, n_steamid)
				Stats[m + 1][WINS] = n_wins
				Stats[m + 1][SCORE] = n_score
				Stats[m + 1][KILLS] = n_kills
				Stats[m + 1][DEATHS] = n_deaths
				Stats[m + 1][TIME] = n_time
				Stats[m + 1][RANKED] = n_ranked
			} 
		}
	}
	return PLUGIN_CONTINUE
}

public RandomizeMap(index, last)
{
	new cFile[128], cMapsFile[64]
	get_pcvar_string(PcvarMaplist, cMapsFile, charsmax(cMapsFile))
	get_configsdir(cFile, charsmax(cFile))
	format(cFile, charsmax(cFile), "%s/%s", cFile, cMapsFile)
	if(file_exists(cFile))
	{
		index++
		new mapsfile_size = file_size(cFile, 1)
		new rand = random_num(0, mapsfile_size)
		new Buffer[128], cmap[32], Len
		get_mapname(cmap, charsmax(cmap))
		if(get_pcvar_num(PcvarCycle) == 2)
		{
			for(new i; i <= mapsfile_size; i++)
			{
				if(last)
				{
					rand = index - 1
					break
				}
				read_file(cFile, i, Buffer, charsmax(Buffer), Len)
				if(Buffer[0] == ';' || !Len)
				{
					continue
				}
				else if(equal(Buffer, cmap))
				{
					rand = i + index
					if(rand >= mapsfile_size)
					{
						if(!last)
						{
							index = 1
						}
						RandomizeMap(index++, 1)
					}
					i = mapsfile_size
				}
			}
		}
		read_file(cFile, rand, Buffer, charsmax(Buffer), Len)
		if(Buffer[0] == ';' || !Len || equal(Buffer, cmap))
		{
			RandomizeMap(index++, last)
			return PLUGIN_CONTINUE
		}
		else
		{
			set_cvar_string("amx_nextmap", Buffer)
		}
	}
	else
	{
		log_amx("Maps file <%s> not found", cFile)
	}
	return PLUGIN_CONTINUE
}

public client_putinserver(id)
{
	if(!get_pcvar_num(PcvarStats) || !get_pcvar_num(PcvarEnable))
	{
		return PLUGIN_CONTINUE
	}
	Temp[id][TEMP_KILLS] = 0
	Temp[id][TEMP_DEATHS] = 0
	Temp[id][TEMP_HS] = 0
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	if(!get_pcvar_num(PcvarStats) || !get_pcvar_num(PcvarEnable))
	{
		return PLUGIN_CONTINUE
	}
	SaveTemp(id)
	return PLUGIN_CONTINUE
}

public CmdReset(id, level, cid)
{
	if(!cmd_access(id, level, cid, 1))
	{
		return PLUGIN_HANDLED
	}
	new cFile[128]
	get_datadir(cFile, charsmax(cFile))
	format(cFile, charsmax(cFile), "%s/fraglimit.dat", cFile)
	if(!file_exists(cFile))
	{
		Recheaded = true
		return PLUGIN_HANDLED
	}
	else
	{
		delete_file(cFile)
		Recheaded = true
	}
	return PLUGIN_CONTINUE
}

public CmdTop15(id)
{
	new iMax = StatNum
	new iLen
	if(iMax > 15)
	{
		iMax = 15
	}
	new lNick[32], lWins[32], lScore[32], lKills[32], lDeaths[32]
	format(lNick, charsmax(lNick), "%L", id, "FL_NICK")
	format(lWins, charsmax(lWins), "%L", id, "FL_WINS")
	format(lScore, charsmax(lScore), "%L", id, "FL_SCORE")
	format(lKills, charsmax(lKills), "%L", id, "FL_KILLS")
	format(lDeaths, charsmax(lDeaths), "%L", id, "FL_DEATHS")
	new MotdMsg[MOTDLEN]
	iLen = format(MotdMsg, MOTDLEN2, "<META http-equiv=Content-Type content='text/html;charset=UTF-8'><body bgcolor=#000000><font color=#FFFFFF><pre>")
	if(get_pcvar_num(PcvarType) == 1)
	{
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%2s %-22.22s         %10s     %10s    %10s    %10s^n^n", "#", lNick, lScore, lWins, lKills, lDeaths)
		for (new i = 0; i < iMax; i++)
		{
			new CheckName[32]
			copy(CheckName, charsmax(CheckName), Stats[i][NAME])
			replace_all(CheckName, charsmax(CheckName), "<", "[")
			replace_all(CheckName, charsmax(CheckName), ">", "]")
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%2d %-22.22s %10d %10d %10d %10d^n", i + 1, CheckName, Stats[i][SCORE], Stats[i][WINS], Stats[i][KILLS], Stats[i][DEATHS])
		}
	}
	else
	{
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%2s %-22.22s %10s %10s %10s %10s^n", "#", lNick, lWins, lScore, lKills, lDeaths)
		for (new i = 0; i < iMax; i++)
		{
			new CheckName[32]
			copy(CheckName, charsmax(CheckName), Stats[i][NAME])
			replace_all(CheckName, charsmax(CheckName), "<", "[")
			replace_all(CheckName, charsmax(CheckName), ">", "]")
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%2s %-22.22s         %10s     %10s    %10s    %10s^n^n", i + 1, CheckName, Stats[i][WINS], Stats[i][SCORE], Stats[i][KILLS], Stats[i][DEATHS])
		}
	}
	iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "^n^n^n<center>%s v%s by %s</center>", PLUGIN, VERSION, AUTHOR)
	show_motd(id, MotdMsg, "FL TOP 15")
	return PLUGIN_CONTINUE
}

public CmdRank(id)
{
	new sname[32], sip[32], ssteamid[34]
	get_user_name(id, sname, charsmax(sname))
	get_user_ip(id, sip, charsmax(sip), 1)
	get_user_authid(id, ssteamid, charsmax(ssteamid))
	new RankPos = fl_find_stats_pos(sname, sip, ssteamid)
	if(RankPos < 0)
	{
		color_print(id, "%L", id, "FL_NO_RANK")
		return PLUGIN_CONTINUE
	}
	else if(!Stats[RankPos][RANKED])
	{
		color_print(id, "%L", id, "FL_NO_RANK")
		return PLUGIN_CONTINUE
	}
	else if(get_pcvar_num(PcvarType) == 1)
	{
		color_print(id, "%L", id, "FL_RANK_1", RankPos + 1, StatNum, Stats[RankPos][SCORE], Stats[RankPos][WINS])
	}
	else
	{
		color_print(id, "%L", id, "FL_RANK_2", RankPos + 1, StatNum, Stats[RankPos][WINS], Stats[RankPos][SCORE])
	}
	return PLUGIN_CONTINUE
}

public CmdRankStats(id)
{
	new sname[32], sip[32], ssteamid[34]
	get_user_name(id, sname, charsmax(sname))
	get_user_ip(id, sip, charsmax(sip), 1)
	get_user_authid(id, ssteamid, charsmax(ssteamid))
	new RankPos = fl_find_stats_pos(sname, sip, ssteamid)
	if(RankPos < 0)
	{
		color_print(id, "%L", id, "FL_NO_RANK")
		return PLUGIN_CONTINUE
	}
	else if(!Stats[RankPos][RANKED])
	{
		color_print(id, "%L", id, "FL_NO_RANK")
		return PLUGIN_CONTINUE
	}
	new iLen
	new lNick[32], lIp[32], lSteamid[32], lWins[32], lScore[32], lKills[32], lDeaths[32]
	format(lNick, charsmax(lNick), "%L", id, "FL_NICK")
	format(lWins, charsmax(lWins), "%L", id, "FL_WINS")
	format(lIp, charsmax(lIp), "%L", id, "FL_IP")
	format(lSteamid, charsmax(lSteamid), "%L", id, "FL_STEAMID")
	format(lScore, charsmax(lScore), "%L", id, "FL_SCORE")
	format(lKills, charsmax(lKills), "%L", id, "FL_KILLS")
	format(lDeaths, charsmax(lDeaths), "%L", id, "FL_DEATHS")
	new MotdMsg[MOTDLEN]
	iLen = format(MotdMsg, MOTDLEN2, "<META http-equiv=Content-Type content='text/html;charset=UTF-8'><body bgcolor=#000000><font color=#FFFFFF><pre>")
	iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%L^n^n", id, "FL_RANK_IS", RankPos + 1, StatNum)
	new CheckName[32]
	copy(CheckName, charsmax(CheckName), Stats[RankPos][NAME])
	replace_all(CheckName, charsmax(CheckName), "<", "[")
	replace_all(CheckName, charsmax(CheckName), ">", "]")
	if(get_pcvar_num(PcvarType) == 1)
	{
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%6s: %s^n%6s: %s^n%6s: %s^n%6s: %d^n%6s: %d^n%6s: %d^n%6s: %d", lNick, CheckName, lIp, Stats[RankPos][IP], lSteamid, Stats[RankPos][STEAMID], lScore, Stats[RankPos][SCORE], lWins, Stats[RankPos][WINS], lKills, Stats[RankPos][KILLS], lDeaths, Stats[RankPos][DEATHS])
	}
	else
	{
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%6s: %s^n%6s: %s^n%6s: %s^n%6s: %d^n%6s: %d^n%6s: %d^n%6s: %d", lNick, CheckName, lIp, Stats[RankPos][IP], lSteamid, Stats[RankPos][STEAMID], lScore, Stats[RankPos][WINS], lWins, Stats[RankPos][SCORE], lKills, Stats[RankPos][KILLS], lDeaths, Stats[RankPos][DEATHS])
	}
	iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "^n^n^n<center>%s v%s by %s</center>", PLUGIN, VERSION, AUTHOR)
	show_motd(id, MotdMsg, "FL Rank Stats")
	return PLUGIN_CONTINUE
}

public PlayerDeath()
{    
	if(!get_pcvar_num(PcvarEnable) || Winner)
	{
		return PLUGIN_HANDLED
	}
	new Frags, Killername[32]
	new Killer = read_data(1)
	new Victim = read_data(2)
	new Headshot = read_data(3)
	if(Killer == Victim || !is_valid_player(Killer) || !is_valid_player(Victim))
	{
		return PLUGIN_CONTINUE
	}
	if(cs_get_user_team(Killer) == cs_get_user_team(Victim) && !get_pcvar_num(PcvarFfa))
	{
		Temp[Killer][TEMP_KILLS]--
	}
	else
	{
		Temp[Killer][TEMP_KILLS]++
		Temp[Victim][TEMP_DEATHS]++
		if(Headshot)
		{
			Temp[Killer][TEMP_HS]++
		}
	}
	get_user_name(Killer, Killername, charsmax(Killername))
	Frags = get_user_frags(Killer) + 1
	new FragsLeft = get_pcvar_num(PcvarLimit) - Frags
	if(FragsLeft == 3)
	{
		set_hudmessage(255, 0, 0, 0.02, 0.5, 2, 0.1, 1.0, 0.025, 1.0, 2)
		ShowSyncHudMsg(0, gMsgHud2, "%L", LANG_PLAYER, "FL_3_LEFT", Killername)
		client_cmd(0,"spk misc/3frags")
	}
	else if(FragsLeft == 2)
	{
		set_hudmessage(255, 255, 0, 0.02, 0.5, 2, 0.1, 1.0, 0.025, 1.0, 2)
		ShowSyncHudMsg(0, gMsgHud2, "%L", LANG_PLAYER, "FL_2_LEFT", Killername)
		client_cmd(0,"spk misc/2frags")
	}
	else if(FragsLeft == 1)
	{
		set_hudmessage(0, 255, 0, 0.02, 0.5, 2, 0.1, 1.0, 0.025, 1.0, 2)
		ShowSyncHudMsg(0, gMsgHud2, "%L", LANG_PLAYER, "FL_1_LEFT", Killername)
		client_cmd(0,"spk misc/1frag")
	}
	else if(Frags >= get_pcvar_num(PcvarLimit) && !Winner)
	{
		Win(Killer, Victim)
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}

public Win(winner, loser) // Thanks to Avalanche for some win and winmotd codes
{
	Winner = true
	Winnerid = winner
	get_user_name(winner, WinnerName, charsmax(WinnerName))
	new sip[32], ssteamid[34]
	get_user_ip(winner, sip, charsmax(sip), 1)
	get_user_authid(winner, ssteamid, charsmax(ssteamid))
	for(new id = 1; id <= get_maxplayers(); id++)
	{
		if(is_user_connected(id))
		{
			SaveTemp(id)
		}
	}
	new winnerstatsid = fl_find_stats_pos(WinnerName, sip, ssteamid)
	Stats[winnerstatsid][WINS] += 1
	if(get_pcvar_num(PcvarMusic))
	{
		client_cmd(0, "stopsound;speak null;mp3 stop;mp3volume 0.5;mp3 play %s", Music[random_num(0, MCOUNT-1)])
	}
	new Float:chattime = get_cvar_float("mp_chattime")
	set_task(floatmax(chattime, 10.0), "GoNextmap")
	message_begin(MSG_ALL, SVC_FINALE)
	write_string("")
	message_end()
	color_print(0, "%L", LANG_PLAYER, "FL_WINNER", WinnerName)
	color_print(0, "%L", LANG_PLAYER, "FL_WINNER", WinnerName)
	color_print(0, "%L", LANG_PLAYER, "FL_WINNER", WinnerName)
	color_print(0, "%L", LANG_PLAYER, "FL_WINNER", WinnerName)
	color_print(0, "%L", LANG_PLAYER, "FL_WINNER", WinnerName)
	new params[2]
	params[0] = winner
	params[1] = loser
	if(get_pcvar_num(PcvarMotd))
	{
		set_task(1.0, "ShowWinMotd",_, params, 2)
	}
	return PLUGIN_CONTINUE
}

public ShowWinMotd(params[2])
{
	new winner = params[0]
	new loser = params[1]
	new losername[32], cnextmap[32], wip[32], wsteamid[34]
	get_user_ip(winner, wip, charsmax(wip), 1)
	get_user_authid(winner, wsteamid, charsmax(wsteamid))
	new winnerpos = fl_find_stats_pos(WinnerName, wip, wsteamid)
	get_cvar_string("amx_nextmap", cnextmap, charsmax(cnextmap))
	get_user_name(loser, losername, charsmax(losername))
	for(new id; id <= get_maxplayers(); id++)
	{
		if(!is_user_connected(id))
		{
			continue
		}
		new MotdMsg[MOTDLEN], iLen, sname[32], sip[32], ssteamid[34]
		get_user_name(id, sname, charsmax(sname))
		get_user_ip(id, sip, charsmax(sip), 1)
		get_user_authid(id, ssteamid, charsmax(ssteamid))
		new sid = fl_find_stats_pos(sname, sip, ssteamid)
		iLen = format(MotdMsg, MOTDLEN2, "<META http-equiv=Content-Type content='text/html;charset=UTF-8'><body bgcolor=black style=line-height:1;color:white><center><font color=00CC00 size=7 face=Georgia>Fraglimit Advanced<p>")
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<font color=green size=6 style=letter-spacing:2px>")
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<div style=height:1px;width:80%%;background-color:green;overflow:hidden></div>")
		if(cs_get_user_team(winner) == CS_TEAM_T)
		{
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<font color=red>%L</font>", id, "FL_LINE_1", WinnerName)
		}
		else if(cs_get_user_team(winner) == CS_TEAM_CT)
		{
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<font color=blue>%L</font>", id, "FL_LINE_1", WinnerName)
		}
		else
		{
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<font color=green>%L</font>", id, "FL_LINE_1", WinnerName)
		}
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<div style=height:1px;width:80%%;background-color:green;overflow:hidden></div>")
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<br><br><font color=white size=3>%L<br><br><br>", id, "FL_LINE_2", WinnerName, get_pcvar_num(PcvarLimit))
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%L<br><br><br>", id, "FL_LINE_3", Stats[winnerpos][TEMPSCORE], Stats[winnerpos][SCORE], Stats[winnerpos][WINS])
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%L<br><br><br>", id, "FL_LINE_4", losername)
		if(sid >= 0 && id != winner)
		{
			iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%L<br><br><br>", id, "FL_LINE_5", Stats[sid][TEMPSCORE], Stats[sid][SCORE], Stats[sid][WINS])
		}
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "%L<br><br><br><br>", id, "FL_LINE_6", cnextmap)
		iLen += format(MotdMsg[iLen], MOTDLEN2 - iLen, "<font size=1>%s v%s by %s</font></font>", PLUGIN, VERSION, AUTHOR)
		show_motd(id, MotdMsg, "FL WINNER")
	}
	return PLUGIN_CONTINUE
}

public plugin_precache()   
{ 
	precache_sound("misc/1frag.wav") 
	precache_sound("misc/2frags.wav") 
	precache_sound("misc/3frags.wav") 
	return PLUGIN_CONTINUE 
}

public GoNextmap()
{
	new cnextmap[32]
	get_cvar_string("amx_nextmap", cnextmap, charsmax(cnextmap))
	server_cmd("changelevel %s", cnextmap)
	return PLUGIN_CONTINUE
}

public Informer()
{
	new id, Frags, FragsLeft, LeaderFrags, PlayersNum, LeaderName[32], CurrentTime[32] , NextMap[32], Message[512]
	for(id = 1; id <= get_maxplayers(); id++)
	{
		if(!is_user_connected(id))
		{
			continue
		}
		else
		{
			Frags = get_user_frags(id)
			if(Frags > LeaderFrags)
			{
				LeaderFrags = Frags
				get_user_name(id, LeaderName, charsmax(LeaderName))
			} 
			PlayersNum++
		}
	}
	for(id = 1; id <= get_maxplayers(); id++)
	{
		new Len
		get_time("%H:%M:%S", CurrentTime, charsmax(CurrentTime))
		Len = format(Message, charsmax(Message), "%L: %s", id, "FL_TIME", CurrentTime)
		Len += format(Message[Len], charsmax(Message) - Len, "^n%L: ", id, "FL_TIMELEFT")
		if(get_cvar_float("mp_timelimit"))
		{
			new a = get_timeleft()
			Len += format(Message[Len], charsmax(Message) - Len, "%d:%02d", (a / 60), (a % 60))
		}
		else
		{
			Len += format(Message[Len], charsmax(Message) - Len, "%L", id, "FL_LAST_ROUND")
		}
		get_cvar_string("amx_nextmap", NextMap, charsmax(NextMap))
		Len += format(Message[Len], charsmax(Message) - Len, "^n%L: %s", id, "FL_NEXTMAP", NextMap)
		if(!Winner)
		{
			if(!strlen(LeaderName))
			{
				format(LeaderName, charsmax(LeaderName), "%L", id, "FL_NONE")
			}
			Len += format(Message[Len], charsmax(Message) - Len, "^n%L: %s [%d/%d]", id, "FL_LEADER", LeaderName, LeaderFrags, get_pcvar_num(PcvarLimit))
		}
		else
		{
			Len += format(Message[Len], charsmax(Message) - Len, "^n%L: %s", id, "FL_WINNER_2", WinnerName)
		}
		Frags = get_user_frags(id)
		FragsLeft = get_pcvar_num(PcvarLimit) - Frags
		Len += format(Message[Len], charsmax(Message) - Len, "^n%L: %d %L", id, "FL_YOU_NEED", FragsLeft, id, "FL_FRAGS")
		Len += format(Message[Len], charsmax(Message) - Len, "^n%L: %d/%d", id, "FL_PLAYERS", PlayersNum, get_maxplayers())
		new LFragsLeft = get_pcvar_num(PcvarLimit) - LeaderFrags
		if(Winner)
		{
			set_hudmessage(0, 255, 0, 0.01, 0.18, 0, 1.0, 1.0, _, _, 1)
		}
		else if(LFragsLeft > 3)
		{
			set_hudmessage(100, 100, 100, 0.01, 0.18, 0, 1.0, 1.0, _, _, 1)
		}
		else if(LFragsLeft == 3)
		{
			set_hudmessage(255, 0, 0, 0.01, 0.18, 1, 1.0, 1.0, _, _, 1)
		}
		else if(LFragsLeft == 2)
		{
			set_hudmessage(255, 255, 0, 0.01, 0.18, 1, 1.0, 1.0, _, _, 1)
		}
		else if(LFragsLeft == 1)
		{
			set_hudmessage(0, 255, 0, 0.01, 0.18, 1, 1.0, 1.0, _, _, 1)
		}
		ShowSyncHudMsg(id, gMsgHud, Message)		
	}
	return PLUGIN_CONTINUE
}

public plugin_end()
{
	for(new id; id <= get_maxplayers(); id++)
	{
		if(is_user_connected(id))
		{
			SaveTemp(id)
		}
	}
	SaveStats()
	return PLUGIN_CONTINUE
}

public SaveStats()
{
	if(!get_pcvar_num(PcvarStats) || !get_pcvar_num(PcvarEnable) || Recheaded)
	{
		return PLUGIN_CONTINUE
	}
	new cFile[128], cLine[256]
	get_datadir(cFile, charsmax(cFile))
	format(cFile, charsmax(cFile), "%s/fraglimit.dat", cFile)
	delete_file(cFile)
	for(new i; i < StatNum; i++)
	{
		format(cLine, charsmax(cLine), "^"%s^" ^"%s^" ^"%s^" ^"%d^" ^"%d^" ^"%d^" ^"%d^" ^"%d^"", Stats[i][NAME], Stats[i][IP], Stats[i][STEAMID], Stats[i][WINS], Stats[i][SCORE], Stats[i][KILLS], Stats[i][DEATHS], Stats[i][TIME])
		write_file(cFile, cLine)
	}
	return PLUGIN_CONTINUE
}

stock SaveTemp(id)
{
	new sname[32], sip[32], ssteamid[34]
	get_user_name(id, sname, charsmax(sname))
	get_user_ip(id, sip, charsmax(sip), 1)
	get_user_authid(id, ssteamid, charsmax(ssteamid))
	new statsid = fl_find_stats_pos(sname, sip, ssteamid)
	if(statsid >= 0 && !Recheaded)
	{
		copy(Stats[statsid][NAME], 31, sname)
		copy(Stats[statsid][IP], 31, sip)
		copy(Stats[statsid][STEAMID], 33, ssteamid)
		Stats[statsid][WINS] += 0
		if(id == Winnerid)
		{
			Stats[statsid][TEMPSCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * 1.5 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
			Stats[statsid][SCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * 1.5 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
		}
		else
		{
			Stats[statsid][TEMPSCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
			Stats[statsid][SCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
		}
		Stats[statsid][KILLS] += Temp[id][TEMP_KILLS]
		Stats[statsid][DEATHS] += Temp[id][TEMP_DEATHS]
		Stats[statsid][TIME] = get_systime(0)
		Temp[id][TEMP_KILLS] = 0
		Temp[id][TEMP_DEATHS] = 0
		Temp[id][TEMP_HS] = 0
	}
	else if(!Recheaded)
	{
		if((StatNum + 1) > MAX_STATS)
		{
			Recheaded = true
			new cFile[128]
			get_datadir(cFile, charsmax(cFile))
			format(cFile, charsmax(cFile), "%s/fraglimit.dat", cFile)
			delete_file(cFile)
			log_amx("Stats limit <%d> recheaded, clear all stats...", MAX_STATS)
			return PLUGIN_CONTINUE
		}
		copy(Stats[StatNum][NAME], 31, sname)
		copy(Stats[StatNum][IP], 31, sip)
		copy(Stats[StatNum][STEAMID], 33, ssteamid)
		Stats[StatNum][WINS] += 0
		if(id == Winnerid)
		{
			Stats[StatNum][TEMPSCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * 1.5 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
			Stats[StatNum][SCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * 1.5 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
		}
		else
		{
			Stats[StatNum][TEMPSCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
			Stats[StatNum][SCORE] += floatround(float(Temp[id][TEMP_KILLS]) / float(Temp[id][TEMP_DEATHS] + 10) * 100.0 * (float(Temp[id][TEMP_HS] + 1) / float(Temp[id][TEMP_KILLS] + 1)), floatround_ceil)
		}
		Stats[StatNum][KILLS] += Temp[id][TEMP_KILLS]
		Stats[StatNum][DEATHS] += Temp[id][TEMP_DEATHS]
		Stats[StatNum][TIME] = get_systime(0)
		Temp[id][TEMP_KILLS] = 0
		Temp[id][TEMP_DEATHS] = 0
		Temp[id][TEMP_HS] = 0
		StatNum++
	}
	return PLUGIN_CONTINUE
}

stock fl_find_stats_pos(const name[], const ip[], const steamid[])
{
	switch(get_pcvar_num(PcvarBy))
	{
		case 1:
		{
			for(new i; i < StatNum; i++)
			{
				if(equal(name, Stats[i][NAME]))
				{
					return i
				}
			}
		}
		case 2:
		{
			for(new i; i < StatNum; i++)
			{
				if(equal(ip, Stats[i][IP]))
				{
					return i
				}
			}
		}
		case 3:
		{
			for(new i; i < StatNum; i++)
			{
				if(equal(steamid, Stats[i][STEAMID]))
				{
					return i
				}
			}
		}
	}
	return -1
}

stock color_print(id, const input[], any:...)
{
	static msg[191]
	vformat(msg, 190, input, 3)
	replace_all(msg, 190, "!g", "^4")
	replace_all(msg, 190, "!y", "^1")
	replace_all(msg, 190, "!t", "^3")
	format(msg, 190, "^x04[FRAGLIMIT]^x01 %s", msg)
	if(id)
	{
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, id)
		write_byte(id)
		write_string(msg)
		message_end()
	}
	else
	{
		for(new i; i <= get_maxplayers(); i++)
		{
			if(!is_user_connected(i))
			{
				continue
			}
			message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, i)
			write_byte(i)
			write_string(msg)
			message_end()
		}
	}
	return 1
}